;Atari OS Routines
;File version 1.01
;2005-03-13 10:35:00

;-----------------------------
;rejestry OS na stronie zerowej

RAMLO   equ     $4

WARMST  equ     $8
DOSVEC  equ     $a  ;adres uruchamiania DOS
DOSINI  equ     $c  ;jeeli ciepy start i by boot z dysku to OS tu skacze po RST

IRQENS  equ     $10 ;shadow IRQEN POKEYa

RTCLOK1 equ     $14 ;zegar systemowy 1/50s (1/60s)
TIMER   equ     $14 ;alias of RTCLOK1
RTCLOK2 equ     $13
RTCLOK3 equ     $12

SAVMSC  equ     $58 ;adres ekranu systemowego

RAMTOP  equ     $6a

ATRACT  equ     $4d ;wpisanie 0 odracza wygaszacz ekranu "ATRACT"

KEYDEF  equ     $79 ;wskanik do tablicy tumaczenia klawiszy z kbcode na atascii


;------------------------------------
;inne rejestry OS


DMACTLS equ     $22f ;shadow of DMACTL ($d400)
COLDST  equ     $244 ;flaga != 0 - bdzie zimny start
PRIORS  equ     $26f ;shadow of PRIOR
GPRIORS equ     PRIORS

COLPM0S  equ    $2c0
COLPM1S  equ    $2c1
COLPM2S  equ    $2c2
COLPM3S  equ    $2c3
COLPF0S  equ    $2c4
COLPF1S  equ    $2c5
COLPF2S  equ    $2c6
COLPF3S  equ    $2c7
COLBAKS  equ    $2c8

PUPBT1  equ     $33D ;power-up bytes
PUPBT2  equ     $33E
PUPBT3  equ     $33F

;------------------------------------
;zmienne OS zwizane z operacjami I/O

ZIOCB   equ     $20 ;12 bajtw aktualnie obsugiwanego IOCB
                    ;przepisane przez OS na stron zerow
                    ;patrz opis IOCB

RUNAD   equ     $2e0 ;adres startu programu binarnego
INITAD  equ     $2e2 ;inicjowanie programu binarnego

KBC     equ     $2f2 ;kod ostatnio wcinitego klawisza
KBCODES equ     $2fc ;kod wcinitego klawisza (kasowalny)


;tablica adresw handlerw zainstalowanych urzdze
HATABS  equ     $31a ;nazwa i adres handlera, max. 11 wpisw po 3 bajty

;bloki IOCB
IOCB    equ     $340 ;kanay IO (8*16 bajtw)
ICHID   equ     $340 ;id urzdzenia - index w HATABS. $ff == nie otwarty
ICDNO   equ     $341 ;numer urzdzenia ustawiany przez OS, np. 2 dla D2:
ICCOM   equ     $342 ;komenda dla urzdzenia
ICSTA   equ     $343 ;OS wpisuje tu status ostatniej operacji
ICBAL   equ     $344 ;adres bufora zawierajcego nazw urzdzenia podczas jego otwierania
ICBAH   equ     $345 ;lub dane podczas transmisji.
ICPTL   equ     $346 ;pomniejszony o jeden adres procedury wysyajcej do urzdzenia jeden bajt.
ICPTH   equ     $347
ICBLL   equ     $348 ;dugo bufora zawierajcego transmitowane dane,
ICBLH   equ     $349 ;po zakoczeniu operacji w tym sowie znajduje si faktyczna dugo przesanego bloku danych.
ICAX1   equ     $34a ;bajt pomocniczy numer 1. Uywany zazwyczaj do okrelenia trybu dostpu do urzdzenia. Odpowiednik drugiego parametru instrukcji OPEN w BASIC-u.
ICAX2   equ     $34b ;bajt pomocniczy numer 2. Odpowiednik trzeciego parametru instrukcji OPEN w BASIC-u.
ICAX3   equ     $34c ;pozostae bajty pomocnicze
ICAX4   equ     $34d
ICAX5   equ     $34e
ICAX6   equ     $34f

;podstawowe komendy CIO (ICCOM)
CIO_open equ 3 ;otwarcie kanau IOCB
CIO_gettext equ 5 ;odczyt wiersza tekstu
CIO_getdata equ 7 ;odczyt bloku danych
CIO_puttext equ 9 ;zapis wiersza tekstu
CIO_putdata equ 11 ;zapis bloku anych
CIO_close equ 12 ;zamknicie kanau IOCB
CIO_getstatus equ 13 ;odczyt stanu urzdzenia

;tryby pracy (ICAX1) dla operacji OPEN
CIO_read equ 4 ;otwarcie do odczytu
CIO_write equ 8 ;do zapisu
CIO_dir equ 6 ;odczyt katalogu dysku
CIO_append equ 9
CIO_readwrite equ 12













;-------------------------------------------------
;Procedury, tablice OS

PUTLINE equ     $c642 ;X - modszy, Y - starszy

DSKINT  equ     $e453 ;obsuga SIO stacji dyskw
CIOMAIN equ     $e456 ;gwna procedura CIO
CIOV    equ     $e456 ;alias CIOMAIN
SIOINT  equ     $e459 ;gwna procedura SIO
SIOV    equ     $e459 ;alias SIOINT
SELFTST equ     $e471 ;SELF-TEST

COLDV   equ     $e477 ;zimny start
COLD    equ     $e477 ;alias COLDV

NEWDEV  equ     $eebc ;dodanie nowego urzdzenia do HTABS
                      ;we: X - nazwa, Y<adres, A>adres
                      ;wy: C = 1 - urzdzenie istnieje, wwczas X = indeks modszego bajtu wektora

